<?xml version='1.0' encoding='utf-8' standalone='yes'?>
<assembly
    xmlns="urn:schemas-microsoft-com:asm.v3"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    manifestVersion="1.0"
    owners="aknanda"
    supportInformation=""
    testers="arpang"
    >
  <assemblyIdentity
      buildType="release"
      language="neutral"
      name="Microsoft-Windows-RasServer"
      processorArchitecture="*"
      version="0.0.0.0"
      />
  <migration
      scope="Upgrade,SvrMig"
      replacementSettingsVersionRange="0"
      replacementVersionRange="6.0-6.1"
      settingsVersion="0"
      alwaysProcess="yes"
      >
    <registerSDF name="RemoteAccessServer"/>
    <registerSDF name="DamgmtTools"/>
    <registerSDF name="RemoteAccessPowershell"/>
    <migXml xmlns="">
        <detects>
          <detect>
            <condition>MigXmlHelper.DoesObjectExist("File","%WinDir%\System32 [rrasmgmt.msc]")</condition>  
          </detect>
       </detects>
      <rules context="System">
        <include>
          <objectSet>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters\Ip [EnableNetbtBcastFwd]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters\Ip [NetworkAdapterGUID]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\Nbf [EnableIn]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\Nbf [AllowNetworkAccess]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [LoggingFlags]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [ServerFlags]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [RouterType]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess [ConfigurationFlags]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [Stamp]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [UsersConfigured]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [ServiceDllUnloadOnStop]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RouterManagers\Ip [GlobalInfo]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RouterManagers\Ipv6 [GlobalInfo]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [AddressSize]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [ViewsSupported]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxChangeNotifyRegistrations]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxOpaqueInfoPointers]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxNextHopsInRoute]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxHandlesReturnedInEnum]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [AddressSize]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [ViewsSupported]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxChangeNotifyRegistrations]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxOpaqueInfoPointers]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxNextHopsInRoute]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxHandlesReturnedInEnum]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IP\StaticAddressPool\* [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [ConfigurationFlags] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [OpenIPSnap] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [OpenMPRSnap] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [RouterPSK] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [Start]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RasMan [Start]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RasAuto [Start]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\ras\* [*] </pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Router EAP\* [*] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IPv6\StaticPrefixPool\* [*]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters\Ipv6 [NetworkAdapterGUID]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\NdpTsp\* [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RasMan\Parameters [DisableIKENameEkuCheck]</pattern>
          </objectSet>
        </include>
        <merge script="MigXmlHelper.SourcePriority()">
          <objectSet>
            <!-- If there is a conflict for any file, this will give priority to source and will ignore the destination-->
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters\Ip [EnableNetbtBcastFwd]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters\Ip [NetworkAdapterGUID]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\Nbf [EnableIn]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\Nbf [AllowNetworkAccess]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [LoggingFlags]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [ServerFlags]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [RouterType]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess [ConfigurationFlags]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [Stamp]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [UsersConfigured]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [ServiceDllUnloadOnStop]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RouterManagers\Ip [GlobalInfo]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RouterManagers\Ipv6 [GlobalInfo]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [AddressSize]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [ViewsSupported]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxChangeNotifyRegistrations]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxOpaqueInfoPointers]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxNextHopsInRoute]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxHandlesReturnedInEnum]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [AddressSize]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [ViewsSupported]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxChangeNotifyRegistrations]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxOpaqueInfoPointers]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxNextHopsInRoute]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxHandlesReturnedInEnum]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IP\StaticAddressPool\* [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [ConfigurationFlags] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [OpenIPSnap] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [OpenMPRSnap] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [RouterPSK] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [Start]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RasMan [Start]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RasAuto [Start]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\ras\* [*] </pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Router EAP\* [*] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IPv6\StaticPrefixPool\* [*]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters\Ipv6 [NetworkAdapterGUID]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\NdpTsp\* [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RasMan\Parameters [DisableIKENameEkuCheck]</pattern>
          </objectSet>
        </merge>
        <processing when="apply-success">
          <script>MigXmlHelper.SyncSCM ("RemoteAccess")</script>
          <script>MigXmlHelper.SyncSCM ("RasMan")</script>
          <script>MigXmlHelper.SyncSCM ("RasAuto")</script>
        </processing>
      </rules>
      <rules context="System">
        <detects>
          <detect>
            <condition negation="No">MigXmlHelper.IsUpgrade()</condition>
          </detect>
        </detects>
        <include>
          <objectSet>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication\* [*]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Accounting\* [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IKEV2\* [*]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Interfaces\* [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\ [ServerAuthCert]</pattern>
          </objectSet>
        </include>
        <merge script="MigXmlHelper.SourcePriority()">
          <objectSet>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication\* [*]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Accounting\* [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IKEV2\* [*]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Interfaces\* [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\ [ServerAuthCert]</pattern>
          </objectSet>
        </merge>
        <processing when="apply-success">
          <script>MigXmlHelper.SyncSCM ("RemoteAccess")</script>
          <script>MigXmlHelper.SyncSCM ("RasMan")</script>
          <script>MigXmlHelper.SyncSCM ("RasAuto")</script>
        </processing>
      </rules>
      <rules context="System">
        <!-- Include only RADIUS and WINDOWS authentication/accounting keys for Server-2-Server migration. -->
        <detects>
          <detect>
            <condition negation="Yes">MigXmlHelper.IsUpgrade()</condition>
          </detect>
        </detects>
        <include>
          <objectSet>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication [*]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Accounting [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication\{1AA7F83F-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication\{1AA7F841-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Accounting\{1AA7F83F-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Accounting\{1AA7F841-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IKEV2\* [*]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Interfaces\* [*]</pattern>
          </objectSet>
        </include>
        <exclude>
          <objectSet>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Interfaces\* [MachineCertificateName]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IKEV2\ [MachineCertificateName]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IKEV2\AllowedTrustedRootCerts\* [*]</pattern>
          </objectSet>
        </exclude>
        <merge script="MigXmlHelper.SourcePriority()">
          <objectSet>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication [*]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Accounting [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication\{1AA7F83F-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication\{1AA7F841-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Accounting\{1AA7F83F-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Accounting\{1AA7F841-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IKEV2\* [*]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Interfaces\* [*]</pattern>
          </objectSet>
        </merge>
        <processing when="apply-success">
          <script>MigXmlHelper.SyncSCM ("RemoteAccess")</script>
          <script>MigXmlHelper.SyncSCM ("RasMan")</script>
          <script>MigXmlHelper.SyncSCM ("RasAuto")</script>
        </processing>
      </rules>
      <plugin file="Microsoft-Windows-RasServer-MigPlugin\RasMigPlugin.dll" classId="{D26AA4A5-92AD-48DB-8D59-95EF0DCE6939}"></plugin>
    </migXml>
    <supportedComponents>
      <supportedComponent>
        <assemblyIdentity 
          name="Microsoft-Windows-RasServer" 
          processorArchitecture="$(build.arch)" 
          type="" 
          publicKeyToken="$(Build.WindowsPublicKeyToken)" 
          language="neutral" 
          buildType="$(build.buildType)" 
          versionScope="nonSxS" 
          buildFilter="" 
          version="6.0.*.*">
        </assemblyIdentity>
    <migXml xmlns="">
      <rules context="System">
        <merge script="MigXmlHelper.SourcePriority()">
          <objectSet>
            <!-- If there is a conflict for any file, this will give priority to source and will ignore the destination-->
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters\Ip [EnableNetbtBcastFwd]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters\Ip [NetworkAdapterGUID]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\Nbf [EnableIn]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\Nbf [AllowNetworkAccess]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [LoggingFlags]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [ServerFlags]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [RouterType]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess [ConfigurationFlags]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [Stamp]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [UsersConfigured]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters [ServiceDllUnloadOnStop]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RouterManagers\Ip [GlobalInfo]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RouterManagers\Ipv6 [GlobalInfo]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [AddressSize]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [ViewsSupported]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxChangeNotifyRegistrations]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxOpaqueInfoPointers]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxNextHopsInRoute]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00002 [MaxHandlesReturnedInEnum]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [AddressSize]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [ViewsSupported]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxChangeNotifyRegistrations]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxOpaqueInfoPointers]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxNextHopsInRoute]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\RoutingTableManager\Instance 00000\AddressFamily 00023 [MaxHandlesReturnedInEnum]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IP\StaticAddressPool\* [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [ConfigurationFlags] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [OpenIPSnap] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [OpenMPRSnap] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [RouterPSK] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess [Start]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RasMan [Start]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RasAuto [Start]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\ras\* [*] </pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Router EAP\* [*] </pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Interfaces\* [*] </pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Parameters\IPv6\StaticPrefixPool\* [*]</pattern>
            <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Parameters\Ipv6 [NetworkAdapterGUID]</pattern>
            <pattern type="Registry">HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\NdpTsp\* [*]</pattern>
            <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RasMan\Parameters [DisableIKENameEkuCheck]</pattern>
          </objectSet>
        </merge>
        <processing when="apply-success">
          <script>MigXmlHelper.SyncSCM ("RemoteAccess")</script>
          <script>MigXmlHelper.SyncSCM ("RasMan")</script>
          <script>MigXmlHelper.SyncSCM ("RasAuto")</script>
        </processing>
      </rules>
          <rules context="System">
            <detects>
              <detect>
                <condition negation="No">MigXmlHelper.IsUpgrade()</condition>
              </detect>
            </detects>
            <merge script="MigXmlHelper.SourcePriority()">
              <objectSet>
                <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication\* [*]</pattern>
                <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Accounting\* [*]</pattern>
              </objectSet>
            </merge>
            <processing when="apply-success">
              <script>MigXmlHelper.SyncSCM ("RemoteAccess")</script>
              <script>MigXmlHelper.SyncSCM ("RasMan")</script>
              <script>MigXmlHelper.SyncSCM ("RasAuto")</script>
            </processing>
          </rules>
          <rules context="System">
            <!-- Include only RADIUS and WINDOWS authentication/accounting keys for Server-2-Server migration. -->
            <detects>
              <detect>
                <condition negation="Yes">MigXmlHelper.IsUpgrade()</condition>
              </detect>
            </detects>
            <merge script="MigXmlHelper.SourcePriority()">
              <objectSet>
                <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication [*]</pattern>
                <pattern type="Registry">HKLM\System\CurrentControlSet\Services\RemoteAccess\Accounting [*]</pattern>
                <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication\{1AA7F83F-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
                <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Authentication\{1AA7F841-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
                <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Accounting\{1AA7F83F-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
                <pattern type="Registry">HKLM\SYSTEM\CurrentControlSet\Services\RemoteAccess\Accounting\{1AA7F841-C7F5-11D0-A376-00C04FC9DA04} [*]</pattern>
              </objectSet>
            </merge>
            <processing when="apply-success">
              <script>MigXmlHelper.SyncSCM ("RemoteAccess")</script>
              <script>MigXmlHelper.SyncSCM ("RasMan")</script>
              <script>MigXmlHelper.SyncSCM ("RasAuto")</script>
            </processing>
          </rules>
      </migXml>      
      </supportedComponent>
      <!-- down-level settings can be applied -->
      <supportedComponent>
        <assemblyIdentity name="Microsoft-Windows-RasServer-DL" version="0.0.0.0" processorArchitecture="*" language="*"></assemblyIdentity>
      </supportedComponent>
    </supportedComponents>
  </migration>
</assembly>
